//=============================================================================
// WeaponLAW.
//=============================================================================
class MSCFireworkLauncher extends MarkistanCityGuns;

//++++++++++++++
//Firework Skins
//++++++++++++++
#exec TEXTURE IMPORT NAME=PurpleFireworkTex FILE=Textures\PurpleFireworkTex.PCX GROUP=Skins
#exec TEXTURE IMPORT NAME=RedFireworkTex FILE=Textures\RedFireworkTex.PCX GROUP=Skins
#exec TEXTURE IMPORT NAME=YellowFireworkTex FILE=Textures\YellowFireworkTex.PCX GROUP=Skins

//--------------
//Sounds
//--------------
#exec AUDIO IMPORT FILE="C:\DeusEx\MarkistanCity\Sounds\FireworkLauncherFire.wav" NAME="FireworkLauncherFire" GROUP="Weapons"

//=============================
//Rocket Mesh
//=============================
#exec MESH IMPORT MESH=FireworkRocket ANIVFILE=MODELS\FireworkRocket_a.3d DATAFILE=MODELS\FireworkRocket_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=FireworkRocket X=0 Y=0 Z=0 PITCH=64 ROLL=0 YAW=0

#exec MESH SEQUENCE MESH=FireworkRocket SEQ=All              STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=FireworkRocket SEQ=FireworkRocket STARTFRAME=0 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=BlackWick FILE=Textures\BlackAlloy.PCX GROUP=Skins // Black
#exec TEXTURE IMPORT NAME=WhiteWick FILE=Textures\RawWhite.PCX GROUP=Skins // White
#exec TEXTURE IMPORT NAME=RawRed FILE=Textures\RawRed.PCX GROUP=Skins // R
#exec TEXTURE IMPORT NAME=RawPurple FILE=Textures\RawPurple.PCX GROUP=Skins // P
#exec TEXTURE IMPORT NAME=RawBlue FILE=Textures\RawBlue.PCX GROUP=Skins // B
#exec TEXTURE IMPORT NAME=RawGreen FILE=Textures\RawGreen.PCX GROUP=Skins // G
#exec TEXTURE IMPORT NAME=RawYellow FILE=Textures\RawYellow.PCX GROUP=Skins // Y
#exec TEXTURE IMPORT NAME=RawOrange FILE=Textures\RawOrange.PCX GROUP=Skins // O

#exec MESHMAP NEW   MESHMAP=FireworkRocket MESH=FireworkRocket
//#exec MESHMAP SCALE MESHMAP=FireworkRocket X=0.008594025 Y=0.008594025 Z=0.008594025
#exec MESHMAP SCALE MESHMAP=FireworkRocket X=0.01718805 Y=0.01718805 Z=0.01718805

#exec MESHMAP SETTEXTURE MESHMAP=FireworkRocket NUM=0 TEXTURE=RawRed
#exec MESHMAP SETTEXTURE MESHMAP=FireworkRocket NUM=1 TEXTURE=PinkMaskTex
#exec MESHMAP SETTEXTURE MESHMAP=FireworkRocket NUM=2 TEXTURE=PinkMaskTex

//=============================
//Pickup[?] Mesh
//=============================
#exec MESH IMPORT MESH=FireworkRocketP ANIVFILE=MODELS\FireworkRocket_a.3d DATAFILE=MODELS\FireworkRocket_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=FireworkRocketP X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=FireworkRocketP SEQ=All              STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=FireworkRocketP SEQ=FireworkRocket STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=FireworkRocketP MESH=FireworkRocketP
//#exec MESHMAP SCALE MESHMAP=FireworkRocketP X=0.008594025 Y=0.008594025 Z=0.008594025
#exec MESHMAP SCALE MESHMAP=FireworkRocketP X=0.01718805 Y=0.01718805 Z=0.01718805

#exec MESHMAP SETTEXTURE MESHMAP=FireworkRocketP NUM=0 TEXTURE=RawRed
#exec MESHMAP SETTEXTURE MESHMAP=FireworkRocketP NUM=1 TEXTURE=WhiteWick
#exec MESHMAP SETTEXTURE MESHMAP=FireworkRocketP NUM=2 TEXTURE=BlackWick

//=============================
//Launcher Pickup
//=============================
#exec MESH IMPORT MESH=FireworkLauncherPickup ANIVFILE=MODELS\FireworkLauncher2Pickup_a.3d DATAFILE=MODELS\FireworkLauncher2Pickup_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=FireworkLauncherPickup X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=FireworkLauncherPickup SEQ=All              STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=FireworkLauncherPickup SEQ=FireworkRocket STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=FireworkLauncherPickup MESH=FireworkLauncherPickup
//#exec MESHMAP SCALE MESHMAP=FireworkLauncherPickup X=0.008594025 Y=0.008594025 Z=0.008594025
#exec MESHMAP SCALE MESHMAP=FireworkLauncherPickup X=0.01718805 Y=0.01718805 Z=0.01718805

#exec MESHMAP SETTEXTURE MESHMAP=FireworkLauncherPickup NUM=0 TEXTURE=RawYellow
#exec MESHMAP SETTEXTURE MESHMAP=FireworkLauncherPickup NUM=1 TEXTURE=RawRed
#exec MESHMAP SETTEXTURE MESHMAP=FireworkLauncherPickup NUM=2 TEXTURE=BlackWick

//=============================
//Launcher 3rd
//=============================
#exec MESH IMPORT MESH=FireworkLauncher3rd ANIVFILE=MODELS\FireworkLauncher23rd_a.3d DATAFILE=MODELS\FireworkLauncher23rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=FireworkLauncher3rd X=150 Y=-375 Z=-105

#exec MESH SEQUENCE MESH=FireworkLauncher3rd SEQ=All              STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=FireworkLauncher3rd SEQ=FireworkRocket STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=FireworkLauncher3rd MESH=FireworkLauncher3rd
//#exec MESHMAP SCALE MESHMAP=FireworkLauncher3rd X=0.008594025 Y=0.008594025 Z=0.008594025
#exec MESHMAP SCALE MESHMAP=FireworkLauncher3rd X=0.01718805 Y=0.01718805 Z=0.01718805

#exec MESHMAP SETTEXTURE MESHMAP=FireworkLauncher3rd NUM=0 TEXTURE=RawYellow
#exec MESHMAP SETTEXTURE MESHMAP=FireworkLauncher3rd NUM=1 TEXTURE=RawRed
#exec MESHMAP SETTEXTURE MESHMAP=FireworkLauncher3rd NUM=2 TEXTURE=BlackWick

//=============================
//Launcher 1st Person
//=============================
#exec MESH IMPORT MESH=FireworkLauncher1st ANIVFILE=MODELS\FireworkLauncher2_a.3d DATAFILE=MODELS\FireworkLauncher2_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=FireworkLauncher1st X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=FireworkLauncher1st SEQ=All              STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=FireworkLauncher1st SEQ=FireworkRocket STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=FireworkLauncher1st MESH=FireworkLauncher1st
//#exec MESHMAP SCALE MESHMAP=FireworkLauncher1st X=0.008594025 Y=0.008594025 Z=0.008594025
#exec MESHMAP SCALE MESHMAP=FireworkLauncher1st X=0.01718805 Y=0.01718805 Z=0.01718805

#exec MESHMAP SETTEXTURE MESHMAP=FireworkLauncher1st NUM=0 TEXTURE=RawYellow
#exec MESHMAP SETTEXTURE MESHMAP=FireworkLauncher1st NUM=1 TEXTURE=RawRed
#exec MESHMAP SETTEXTURE MESHMAP=FireworkLauncher1st NUM=2 TEXTURE=BlackWick

#exec MESH SEQUENCE MESH=FireworkLauncher1st SEQ=All 		STARTFRAME=0    NUMFRAMES=18
#exec MESH SEQUENCE MESH=FireworkLauncher1st SEQ=Select 	STARTFRAME=0    NUMFRAMES=3 	RATE=4.2 	GROUP=Select
#exec MESH SEQUENCE MESH=FireworkLauncher1st SEQ=Shoot		STARTFRAME=3	NUMFRAMES=4	RATE=11.25
#exec MESH SEQUENCE MESH=FireworkLauncher1st SEQ=Down		STARTFRAME=7	NUMFRAMES=3	RATE=4.8
#exec MESH SEQUENCE MESH=FireworkLauncher1st SEQ=ReloadBegin	STARTFRAME=11	NUMFRAMES=3	RATE=4.2
#exec MESH SEQUENCE MESH=FireworkLauncher1st SEQ=Reload		STARTFRAME=13	NUMFRAMES=2	RATE=3.334
#exec MESH SEQUENCE MESH=FireworkLauncher1st SEQ=ReloadEnd	STARTFRAME=15	NUMFRAMES=3	RATE=7.5
#exec MESH SEQUENCE MESH=FireworkLauncher1st SEQ=Idle1		STARTFRAME=2	NUMFRAMES=1	RATE=0.2
#exec MESH SEQUENCE MESH=FireworkLauncher1st SEQ=Idle2		STARTFRAME=2	NUMFRAMES=1	RATE=0.2
#exec MESH SEQUENCE MESH=FireworkLauncher1st SEQ=Idle3		STARTFRAME=2	NUMFRAMES=1	RATE=0.2
#exec MESH SEQUENCE MESH=FireworkLauncher1st SEQ=Still		STARTFRAME=2	NUMFRAMES=1

state Reload
{
ignores Fire, AltFire;

	function float GetReloadTime()
	{
		local float val;

		val = ReloadTime;

		if (ScriptedPawn(Owner) != None)
		{
			val = ReloadTime * (ScriptedPawn(Owner).BaseAccuracy*2+1);
		}
		else if (DeusExPlayer(Owner) != None)
		{
			// check for skill use if we are the player
			val = GetWeaponSkill();
			val = ReloadTime + (val*ReloadTime);
		}

		return val;
	}

	function NotifyOwner(bool bStart)
	{
		local DeusExPlayer player;
		local ScriptedPawn pawn;

		player = DeusExPlayer(Owner);
		pawn   = ScriptedPawn(Owner);

		if (player != None)
		{
			if (bStart)
				player.Reloading(self, GetReloadTime()+(1.0/AnimRate));
			else
			{
				player.DoneReloading(self);
			}
		}
		else if (pawn != None)
		{
			if (bStart)
				pawn.Reloading(self, GetReloadTime()+(1.0/AnimRate));
			else
				pawn.DoneReloading(self);
		}
	}

	function BeginState()
	{
		Super.BeginState();
		
		if (ClipCount < 1)
		{
			GoToState('Idle');
			return;
		}
	}

Begin:
	FinishAnim();

	// only reload if we have ammo left
	if (AmmoType.AmmoAmount > 0)
	{
		if (( Level.NetMode == NM_DedicatedServer ) || ((Level.NetMode == NM_ListenServer) && Owner.IsA('DeusExPlayer') && !DeusExPlayer(Owner).PlayerIsListenClient()))
		{
			ClientReload();
			Sleep(GetReloadTime());
			ReadyClientToFire( True );
		}
		else
		{
			bWasZoomed = bZoomed;
			if (bWasZoomed)
				ScopeOff();

			Owner.PlaySound(CockingSound, SLOT_None,,, 1024);		// CockingSound is reloadbegin
			PlayAnim('ReloadBegin');
			NotifyOwner(True);
			FinishAnim();
			LoopAnim('Reload');
			Sleep(GetReloadTime());
			Owner.PlaySound(AltFireSound, SLOT_None,,, 1024);		// AltFireSound is reloadend
			PlayAnim('ReloadEnd');
			FinishAnim();
			NotifyOwner(False);

			if (bWasZoomed)
				ScopeOn();

			ClipCount = 0;
		}
	}
	GotoState('Idle');
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	// If this is a netgame, then override defaults
	if ( Level.NetMode != NM_StandAlone )
	{
		HitDamage = mpHitDamage;
		BaseAccuracy = mpBaseAccuracy;
		ReloadTime = mpReloadTime;
		AccurateRange = mpAccurateRange;
		MaxRange = mpMaxRange;
		ReloadCount = mpReloadCount;
	}
}

function PostBeginPlay()
{
   Super.PostBeginPlay();
   bWeaponStay=False;
}

// Become a pickup
// Weapons that carry their ammo with them don't vanish when dropped
function BecomePickup()
{
	Super.BecomePickup();
   if (Level.NetMode != NM_Standalone)
      if (bTossedOut)
         Lifespan = 0.0;
}

defaultproperties
{
     PickupAmmoCount=0
     LowAmmoWaterMark=0
     GoverningSkill=Class'DeusEx.SkillWeaponRifle'
     NoiseLevel=2.000000
     EnviroEffective=ENVEFF_Air
     ShotTime=0.300000
     reloadTime=1.375000
     HitDamage=100
     maxRange=24000
     AccurateRange=14400
     BaseAccuracy=0.600000
     bHasMuzzleFlash=False
     recoilStrength=1.000000
     mpHitDamage=100
     mpBaseAccuracy=0.600000
     mpAccurateRange=14400
     mpMaxRange=14400
     AmmoName=Class'MarkistanCity.AmmoFireworks'
     ReloadCount=1
     FireOffset=(X=23.000000,Y=18.000000,Z=-13.000000)
     ProjectileClass=Class'MarkistanCity.MSCFireworkRocket'
     shakemag=500.000000
     FireSound=Sound'FireworkLauncherFire'
     SelectSound=Sound'DeusExSounds.Weapons.LAWSelect'
     InventoryGroup=16
     ItemName="Prototype Markistanian Firework Launcher"
     PlayerViewOffset=(X=23.000000,Y=-18.000000,Z=-13.000000)
     PlayerViewMesh=LodMesh'FireworkLauncher1st'
     PickupViewMesh=LodMesh'FireworkLauncherPickup'
     ThirdPersonMesh=LodMesh'FireworkLauncher3rd'
     LandSound=Sound'DeusExSounds.Generic.DropLargeWeapon'
     Icon=Texture'DeusExUI.Icons.BeltIconLAW'
     largeIcon=Texture'DeusExUI.Icons.LargeIconLAW'
     CockingSound=Sound'DeusExSounds.Weapons.GEPGunReload'
     largeIconWidth=166
     largeIconHeight=47
     invSlotsX=4
     Description="This modified rocket launcher fires a high-powered firework rocket, with easily enough power to kill many men."
     beltDescription="FIREWORKS"
     Mesh=LodMesh'FireworkLauncherPickup'
     CollisionRadius=22.000000
     CollisionHeight=6.800000
     Mass=30.000000
     Scaleglow=2.000000
     mpReloadCount=1
}
